/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.compat;

import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class FogHelper {
    private static final float FAR_PLANE_THRESHOLD_EXP = (float)Math.log(526.3157958984375);
    private static final float FAR_PLANE_THRESHOLD_EXP2 = MathHelper.func_76129_c((float)FAR_PLANE_THRESHOLD_EXP);

    public static float getFogEnd() {
        return GlStateManager.field_179155_g.field_179046_e;
    }

    public static float getFogStart() {
        return GlStateManager.field_179155_g.field_179045_d;
    }

    public static float getFogDensity() {
        return GlStateManager.field_179155_g.field_179048_c;
    }

    public static ChunkFogMode getFogMode() {
        int mode = GlStateManager.field_179155_g.field_179047_b;
        if (mode == 0 || !GlStateManager.field_179155_g.field_179049_a.field_179201_b) {
            return ChunkFogMode.NONE;
        }
        switch (mode) {
            case 2048: 
            case 2049: {
                return ChunkFogMode.EXP2;
            }
            case 9729: {
                return ChunkFogMode.LINEAR;
            }
        }
        throw new UnsupportedOperationException("Unknown fog mode: " + mode);
    }

    public static float getFogCutoff() {
        int mode = GlStateManager.field_179155_g.field_179047_b;
        switch (mode) {
            case 9729: {
                return FogHelper.getFogEnd();
            }
            case 2048: {
                return FAR_PLANE_THRESHOLD_EXP / FogHelper.getFogDensity();
            }
            case 2049: {
                return FAR_PLANE_THRESHOLD_EXP2 / FogHelper.getFogDensity();
            }
        }
        return 0.0f;
    }

    public static float[] getFogColor() {
        EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
        return new float[]{entityRenderer.field_175080_Q, entityRenderer.field_175082_R, entityRenderer.field_175081_S, 1.0f};
    }
}

